﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.Net.Sockets;
using System.Threading;

namespace Remoting
{
	public class RServerSocketAcceptor : IDisposable
	{
		private TcpListener Listener;

		private bool Accepting = true;

		public event Action<RServerSocket> Accepted;

		public RServerSocketAcceptor(IPAddress address, int port)
		{
			Listener = new TcpListener(address, port);
			Listener.Start();

			ThreadPool.QueueUserWorkItem(Accept);
		}

		private void Accept(object state)
		{
			while (Accepting)
			{
				TcpClient client = Listener.AcceptTcpClient();
				if(Accepted != null)
					Accepted.BeginInvoke(new RServerSocket(client), null, null);
			}
		}

		#region IDisposable Members

		public void Dispose()
		{
			Accepting = false;
		}

		#endregion
	}
}
